# načteme celý textový soubor do paměti jako seznam jednotlivých řádek
with open('filmy_1.csv', mode='tr', encoding='utf-8') as soubor:
    řádky = soubor.readlines()

# nyní můžeme procházet prvky seznamu, tedy jednotlivé řádky, a něco s nimi dělat
# ~ třeba vypsat je v opačném pořadí (ale za cenu zabrání dvojnásobku paměti, protože jsme díky [::-1] vyrobili novou kopii seznamu, jen s opačným pořadím prvků)
for řádka in řádky[::-1]:
    pořadí, název, rok, režisér = řádka.strip().split(';')
    print(f'{pořadí:0>2}) {název[21:]}\n\t({rok}, r. {režisér})')
